<?php
require("../includes/header.php");

// appname
require_once("../config/connection.php");
$query = "SELECT * FROM app_settings";

$result = $mysqli->query($query);
$row = $result->fetch_assoc();
$appname = $row['appname'];


$admob_app_open_id = $row['admob_app_open_id'];
$admob_interstitial_id = $row['admob_interstitial_id'];
$admob_banner_id = $row['admob_banner_id'];
$is_admob_app_open_enabled = $row['is_admob_app_open_enabled'];
$is_admob_interstitial_enabled = $row['is_admob_interstitial_enabled'];
$is_admob_banner_enabled = $row['is_admob_banner_enabled'];
 $ad_frequency = $row['ad_frequency'];

// Update settings if form is submitted
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
   
    $admob_app_open_id = $_POST['admob_app_open_id'];
    $admob_interstitial_id = $_POST['admob_interstitial_id'];
    $admob_banner_id = $_POST['admob_banner_id'];

    $is_admob_app_open_enabled = isset($_POST['is_admob_app_open_enabled']) ? 1 : 0;
    $is_admob_interstitial_enabled = isset($_POST['is_admob_interstitial_enabled']) ? 1 : 0;
    $is_admob_banner_enabled = isset($_POST['is_admob_banner_enabled']) ? 1 : 0;
    $ad_frequency = $_POST['ad_frequency'];

    $stmt = $mysqli->prepare(
        "UPDATE app_settings SET admob_app_open_id = ?, admob_interstitial_id = ?, admob_banner_id = ?, is_admob_app_open_enabled = ?, is_admob_interstitial_enabled = ?, is_admob_banner_enabled = ?, ad_frequency = ?"
    );

    $stmt->bind_param(
        "sssiiii",
      
        $admob_app_open_id,
        $admob_interstitial_id,
        $admob_banner_id,
        $is_admob_app_open_enabled,
        $is_admob_interstitial_enabled,
        $is_admob_banner_enabled,
        $ad_frequency
    );

    if ($stmt->execute()) {
        $successMessage = "Data updated successfully.";
    } else {
        $errorMessage = "Update failed: " . $stmt->error;
    }
}
?>
<title>Advertisement Settings</title>

<meta name="description" content="" />
</head>
<body>
    <div class="layout-wrapper layout-content-navbar">
        <div class="layout-container">
            <?php require("../includes/sidebar.php") ?>
            <div class="layout-page">
                <?php require("../includes/navbar.php") ?>
                <div class="content-wrapper">
                    <div class="container-xxl flex-grow-1 container-p-y">
                        <div class="row">
                            <div class="col-md-6">
                                <form method="POST">
                                    <div class="row mb-6 g-6">
                                        <div class="card mb-6">
                                            <h5 class="card-header">Advertisement Settings</h5>
                                            <div class="card-body">
                                                <small class="text-light fw-medium d-block">ADMOB BANNER ID</small>
                                                <div class="input-group">
                                                    <div class="input-group-text">
                                                        <input
                                                            class="form-check-input mt-0"
                                                            type="checkbox"
                                                            name="is_admob_banner_enabled"
                                                            value="1"
                                                            <?php if ($is_admob_banner_enabled) echo "checked"; ?>
                                                        />
                                                    </div>
                                                    <input type="text" name="admob_banner_id" class="form-control" value="<?php echo $admob_banner_id; ?>" />
                                                </div>

                                                <br/>
                                                <small class="text-light fw-medium d-block">ADMOB INTERSTITIAL ID</small>
                                                <div class="input-group">
                                                    <div class="input-group-text">
                                                        <input
                                                            class="form-check-input mt-0"
                                                            type="checkbox"
                                                            name="is_admob_interstitial_enabled"
                                                            value="1"
                                                            <?php if ($is_admob_interstitial_enabled) echo "checked"; ?>
                                                        />
                                                    </div>
                                                    <input type="text" name="admob_interstitial_id" class="form-control" value="<?php echo $admob_interstitial_id; ?>" />
                                                </div>

                                                <br/>
                                                <small class="text-light fw-medium d-block">ADMOB OPEN APP ID</small>
                                                <div class="input-group">
                                                    <div class="input-group-text">
                                                        <input
                                                            class="form-check-input mt-0"
                                                            type="checkbox"
                                                            name="is_admob_app_open_enabled"
                                                            value="1"
                                                            <?php if ($is_admob_app_open_enabled) echo "checked"; ?>
                                                        />
                                                    </div>
                                                    <input type="text" name="admob_app_open_id" class="form-control" value="<?php echo $admob_app_open_id; ?>" />
                                                </div>
                                            
                                                <br/>
                                                
                                                <div class="mb-4">
  <label for="formRange2" class="form-label">
    Interstitial/Open-App Ads Frequency (in seconds): 
    <span id="rangeValue">0</span>
  </label>
  <input type="range" name="ad_frequency" class="form-range" min="0" max="86400" value="<?php echo $ad_frequency; ?>" id="formRange2" />
</div>

<script>
  // Select the range input and the span element to display the value
  const rangeInput = document.getElementById('formRange2');
  const rangeValue = document.getElementById('rangeValue');

  // Update the displayed value when the slider value changes
  rangeInput.addEventListener('input', () => {
    rangeValue.textContent = rangeInput.value;
  });

  // Initialize the displayed value on page load
  rangeValue.textContent = rangeInput.value;
</script>

                      
                      
                                                <button class="btn btn-primary" type="submit">Save Settings</button>
                                            </div>
                                        </div>
                                    </div>
                                </form>
                                <hr/>
                                <?php if (isset($successMessage)) echo "<div id='alert' class='alert alert-dark' role='alert'>$successMessage</div>"; ?>
                                <?php if (isset($errorMessage)) echo "<div id='alert' class='alert alert-danger' role='alert'>$errorMessage</div>"; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</body>
<script>
    setTimeout(function() {
        var successMessageElement = document.getElementById('alert');
        if (successMessageElement) {
            successMessageElement.remove();
        }
    }, 3000);
</script>
<?php require("../includes/footer.php"); ?>
</html>
